;; This example shows how to dump the upper ROM
;; of an Amstrad CPC, CPC+ or KC Compact.
;;
;; When active, the selected "upper"/expansion ROM is readable in the 
;; range &c000-&ffff.
;;
;; An expansion ROM is:
;; - The upper 16K of the internal 32K ROM containing Locomotive BASIC
;; - The internal AMSDOS ROM in a CPC664 or CPC6128
;; - A ROM in a interface or rom-board which is connected to the computer.
;; (e.g. DDI-1 disc interface)

;; firmware function to activate the upper rom
.kl_rom_select		equ &b90f
;; firmware function to restore the rom state
.kl_rom_restore		equ &b90c

;;----------------------------------------------------------

;; When activated, the upper rom will be readable from &c000-&ffff.
;; The program will not function if it is in this range.
org &4000

;;-----------------------------------------
;; select the upper rom and enable it

ld c,0						;; index of ROM
call kl_rom_select

;; store the previous state
ld a,b
ld (rom_previous_state),a

;; store the index of the previously selected ROM
ld a,c
ld (urom_index),a

;;-----------------------------------------
;; copy rom data to store
ld hl,&c000				;; source
ld de,rom_data			;; dest
ld bc,&4000				;; length
ldir

;;-----------------------------------------
;; restore the previously selected ROM
;; (this will also enable it)
ld a,(urom_index)
ld c,a
call kl_rom_select

;;-----------------------------------------
;; restore the previous rom state
ld a,(rom_previous_state)
call kl_rom_restore
ret

;;-----------------------------------------

;; stores the previous state of the rom configuration
.rom_previous_state defb 0

;; stores the index of the previously selected upper rom
.urom_index defb 0

;; a buffer to store the 16k of rom data
.rom_data equ $+1


